% Author: Layla S. Mayboudi
% 2021-05-27

% Note:
% This code should be run before running the code Pump_Heating_MATLAB_Script
% The geometry data, set formula, and labels (gd sf ns) are to be exported herein.
% (gd sf ns) are to be exported after the solution is complete by selecting
% the "Export Geometry Description" under the "Draw" item from the 
% PDE Modeler Application toolbar.
% This step is to be coinducted before running the code Pump_Heating_MATLAB_Script.
% Do not choose to save changes if the code prompts if you wish to do so.

% The script presented herein is the revised coded version of the autogenerated script by the MATLAB PDE Modeler Application. 
% The purpose is to facilitate the learning process for highly coding
% enthusiasts.
% The scholars may choose to modify the script for their own learning applications. 
% Care is to be taken when using the program, as the program and its functionalities are very detailed.

% The initial version of this script comment (autogenerated by the MATLAB PDE Modeler Application) reads:
% "This script is written and read by pdetool and should NOT be edited."
% There are two recommended alternatives:
% 1) Export the required variables from pdetool and create a MATLAB script
%    to perform operations on these.
% 2) Define the problem completely using a MATLAB script. See
%    https://www.mathworks.com/help/pde/examples.html for examples
%    of this ap1proach."


function pdemodel
clc; clf; close all; clear all;
[pde_fig,ax]=pdeinit;
pdetool('appl_cb',9);
set(ax,'DataAspectRatio',[1 1 1]);
set(ax,'PlotBoxAspectRatio',[1 1.2 2]);
set(ax,'XLimMode','auto');
set(ax,'YLimMode','auto');
set(ax,'XTick',[ -1.5,-1.3,-1.1,-0.9,-0.7,-0.5,-0.3,-0.1,0.1,0.3,0.5,0.7,0.9,1.1,1.3,1.5,1.7]);
set(ax,'YTick',[-1,-0.8,-0.6,-0.4,-0.2,0,0.2,0.4,0.6,0.8,1,1.2,1.4]);
setappdata(ax,'extraspacex','0.1');
setappdata(ax,'extraspacey','0.1');
pdetool('gridon','on');

% Geometry description:
pdeellip(0,0,0.5,0.5,0,'C1');
pdeellip(0,0,0.075,0.175,0,'E1');
pdeellip(-0.175,0.03,0.180,0.034,0,'E2');
pderect([-0.5 -0.25 0.75 0],'R1');
pderect([-0.49 -0.26 0.735 0.015],'R2');
pderect([0.1 0.3 0.6 0.3],'R3');

% Set formula:
set(findobj(get(pde_fig,'Children'),'Tag','PDEEval'),'String','C1+E1+E2+R1+R2+R3')

% Boundary conditions:
pdetool('changemode',0)
pdesetbd(1,'neu',1,'10','500')
pdesetbd([4,22:24,26],'neu',1,'10','0')
pdesetbd(18,'dir',1,'1','15')
pdesetbd(21,'dir',1,'1','15')
pdesetbd(2,'dir',1,'1','45')
pdesetbd(6,'dir',1,'1','35')

% Mesh generation:
setappdata(pde_fig,'trisize',1.5);
setappdata(pde_fig,'Hgrad',1.2); %or use the maximum grid size instead: 'Hmax'
setappdata(pde_fig,'refinemethod','regular');
setappdata(pde_fig,'jiggle',char('on','mean','14'));
setappdata(pde_fig,'MesherVersion','preR2013a');
pdetool('initmesh')
pdetool('refine')
pdetool('jiggle')

% The following coefficients can be concatenated in Excel, note the order;
% c, a, d, and f are PDE coefficients, which can be exported from:
% PDE > Export PDE Coefficients, in that order (c, a, d, f).

% heat convection coefficient array
a =	'10!0!10!0!0!0!0!0!0!10!0!0!0';  
% thermal conductivity array
c =	'210!0.6305!210!210!210!0.6305!210!0.6305!0.6305!210!0.6305!0.6305!0.6305'; 
% density*heat capacity array
d =	'(2689.9).*(900)!(988).*(4181)!(2689.9).*(900)!(2689.9).*(900)!(2689.9).*(900)!(988).*(4181)!(2689.9).*(900)!(988).*(4181)!(988).*(4181)!(2689.9).*(900)!(988).*(4181)!(988).*(4181)!(988).*(4181)';
% heat generation+heat convection coefficient * external temperature array
f =	'(0)+(10).*(30)!(0)+(0).*(30)!(2000)+(10).*(30)!(4000)+(0).*(30)!(0)+(0).*(30)!(0)+(0).*(30)!(0)+(0).*(30)!(0)+(0).*(30)!(0)+(0).*(30)!(10000)+(10).*(30)!(0)+(0).*(30)!(-6000)+(0).*(30)!(-6000)+(0).*(30)';

% The following coefficients can be concatenated in Excel or any database management tool.
% Note the order, aa, bb, cc, dd, ee, and ff are PDE specifications, which are to be defined 
% for each domain and are accessible through:
% PDE Mode > PDE Specification, in that order (rho, C, k, Q, h, Text).

% density array
aa = '2689.9!988!2689.9!2689.9!2689.9!988!2689.9!988!988!2689.9!988!988!988   '; 
% density*heat capacity array
bb = '900!4181!900!900!900!4181!900!4181!4181!900!4181!4181!4181              '; 
% thermal conductivity array
cc = '210!0.6305!210!210!210!0.6305!210!0.6305!0.6305!210!0.6305!0.6305!0.6305'; 
% heat generation array
dd = '0!0!2000!4000!0!0!0!0!0!10000!0!-6000!-6000                             '; 
% heat convection coefficient array
ee = '10!0!10!0!0!0!0!0!0!10!0!0!0                                            '; 
% ambient temperature array
ff = '30!30!30!30!30!30!30!30!30!30!30!30!30                                  '; 

% PDE coefficients:
pdeseteq(2,c,a,f,d,'0:100','25','0.0','[0 100]')
setappdata(pde_fig,'currparam',[aa;bb;cc;dd;ee;ff])

% Solve parameters:
setappdata(pde_fig,'solveparam',char('0','7272','10','pdeadworst',...
'0.5','longest','0','1E-4','','fixed','Inf'))

% Plotflags and user data strings:
setappdata(pde_fig,'plotflags',[1 1 1 1 2 1 6 1 0 1 0 5001 1 1 0 1 0 1]);
setappdata(pde_fig,'colstring','');
setappdata(pde_fig,'arrowstring','');
setappdata(pde_fig,'deformstring','');
setappdata(pde_fig,'heightstring','');

% Solve PDE:
pdetool('solve')